package raytracer;


public class ABunchOfSpheres {

    public void render_scene(String filename, int count) {

        float acceleration_factor = 40.0f;

        Point projectile1_position = new Point(-0f + 11f*(float)Math.cos((double)count/acceleration_factor),
                -4f + 15f*(float)Math.sin((double)count/ acceleration_factor),
                17f);

        Point projectile2_position = new Point(1f + 7f*(float)Math.sin((double)count/acceleration_factor),
                +3f + 10f*(float)Math.cos((double) count / acceleration_factor),
                14f);

        Point projectile3_position = new Point(1f + 6f*(float)Math.sin((double)count/acceleration_factor),
                +2f - 2f*(float)Math.cos((double) count / acceleration_factor),
                12f);


        System.out.println("["+Thread.currentThread().getId()+"] Rendering frame #" + count);

        // Defining the scene
        Point eye = new Point(-0f,-0f,-20f);
        Point UL = new Point(-10f,10f,15f);
        Point UR = new Point(10f,10f,15f);
        Point LR = new Point(10f,-10f,15f);
        Point LL = new Point(-10f,-10f,15f);
        int height = 1500;
        int width =1500;

        Film sceneFilm = new Film(height,width);
        Scene runningScene = new Scene(eye,UL,UR,LL,LR,height,width,sceneFilm);

        /* Static objects */

        Shape static_shapes[] = new Shape[12];
        int shape_count = 0;

        Triangle triangle = new Triangle(new Point(-50f,-34f,80f), new Point(0f,40f,80f), new Point(60f,-30f,80f));
        triangle.kd = new ColorRT(.0f, .0f, .0f);
        triangle.ka = new ColorRT(.5f, .5f, .5f);
        static_shapes[shape_count++] = triangle;

        Sphere big_sphere = new Sphere(11.0f, new Point(-4f,-10f,25f));
        big_sphere.kd = new ColorRT(.5f, .5f, .5f);
        big_sphere.ka = new ColorRT(.1f, .1f, .3f);
        static_shapes[shape_count++] = big_sphere;

        Sphere small_sphere1 = new Sphere(3.0f, new Point(2.5f,-12f,23f));
        small_sphere1.kd = new ColorRT(.5f, .5f, .5f);
        small_sphere1.ka = new ColorRT(.3f, .1f, .0f);
        static_shapes[shape_count++] = small_sphere1;

        Sphere knob = new Sphere(2.0f, new Point(0f,-15f,16f));
        knob.kd = new ColorRT(.5f, .5f, .5f);
        knob.ka = new ColorRT(.1f, .2f, .1f);
        static_shapes[shape_count++] = knob;

        Sphere knob2 = new Sphere(2.0f, new Point(-7f,-14f,15f));
        knob2.kd = new ColorRT(.5f, .5f, .5f);
        knob2.ka = new ColorRT(.3f, .1f, .1f);
        static_shapes[shape_count++] = knob2;

        Sphere knob3 = new Sphere(2.0f, new Point(0f,-6f,15f));
        knob3.kd = new ColorRT(.5f, .5f, .5f);
        knob3.ka = new ColorRT(.2f, .2f, .2f);
        static_shapes[shape_count++] = knob3;

        Sphere orion = new Sphere(30.0f, new Point(+35f,+35f,85f));
        orion.kd = new ColorRT(.5f, .5f, .4f);
        orion.ka = new ColorRT(.1f, .1f, .1f);
        static_shapes[shape_count++] = orion;

        Sphere orion2 = new Sphere(20.0f, new Point(-35f,+35f,80f));
        orion2.kd = new ColorRT(.5f, .5f, .1f);
        orion2.ka = new ColorRT(.3f, .3f, .1f);
        static_shapes[shape_count++] = orion2;

        Sphere orion3 = new Sphere(10.0f, new Point(-45f,+15f,70f));
        orion3.kd = new ColorRT(.5f, .5f, .9f);
        orion3.ka = new ColorRT(.2f, .2f, .2f);
        static_shapes[shape_count++] = orion3;

        Sphere projectile1 = new Sphere(4.5f, projectile1_position);
        projectile1.kd = new ColorRT(.5f, .0f, .0f);
        projectile1.ka = new ColorRT(.0f, .0f, .0f);
        static_shapes[shape_count++] = projectile1;

        Sphere projectile2 = new Sphere(1.5f, projectile2_position);
        projectile2.kd = new ColorRT(.1f, .8f, .1f);
        projectile2.ka = new ColorRT(.1f, .0f, .0f);
        static_shapes[shape_count++] = projectile2;

        Sphere projectile3 = new Sphere(2.5f, projectile3_position);
        projectile3.kd = new ColorRT(.1f, .8f, .1f);
        projectile3.ka = new ColorRT(.1f, .1f, .0f);
        static_shapes[shape_count++] = projectile3;

        Light[] lts = new Light[3];
        Vector3D light_vector = new Vector3D(0f+2f*(count), +10f-2f*(100-count), +01.1f);
        lts[0] = new LightDirected(light_vector, new ColorRT(1f, 1f, 1f));
        light_vector = new Vector3D(40f+2f*(100-count), -30f-1f*count, +5f);
        lts[1] = new LightDirected(light_vector, new ColorRT(0.3f, 0.3f, 0.4f));
        light_vector = new Vector3D(0f+2f*(count), -30f-1f*count, +15f);
        lts[2] = new LightDirected(light_vector, new ColorRT(0.3f, 0.3f, 0.4f));

        runningScene.render(static_shapes, lts, filename);
    }

}
