package raytracer;

public class Camera {
	public Point eye;
	public float x_inc,y_inc;
	public Point UL;
	
	public Camera(Point e,Scene theScene){
		eye = e;
		UL = theScene.UL;
		x_inc = ((theScene.UL).pSubtract(theScene.UR)).length() / theScene.imgWidth;
		y_inc = ((theScene.UR).pSubtract(theScene.LR)).length() / theScene.imgHeight;
	}
	
	public Ray generateRay(Sample currentSample){
		float x = x_inc * (currentSample.x+1);
		float y = y_inc * (currentSample.y+1);
		//System.out.println(UL.z);
		Point tempPoint = new Point(UL.x + x,UL.y - y,UL.z);
		Vector3D tempVec = eye.pSubtract(tempPoint);
		tempVec.normalize();
		return new Ray(eye,new Vector3D(UL.x + x,UL.y - y,UL.z));
	}
}
