package raytracer;

public class ColorRT {
	public float r,g,b;
	
	public ColorRT(float x,float y,float z){
		r=x;g=y;b=z; }
	
	public ColorRT cAdd(ColorRT n) {
		return new ColorRT(r+n.r,g+n.g,b+n.b); }
	public ColorRT cSubtract(ColorRT n) {
		return new ColorRT(r-n.r,g-n.g,b-n.b); }
	public ColorRT sMultiply(float scalar) {
		return new ColorRT(r * scalar,g * scalar,b * scalar); }
	public ColorRT sDivide(float scalar){
		return new ColorRT(r * (1.0f/scalar),g * (1.0f/scalar),b * (1.0f/scalar)); } 
	public ColorRT multColors(ColorRT n) {
		return new ColorRT(r * n.r,g * n.g,b * n.b);
	}
    public String toString() {
        return new String("[Color: "+r+" , "+g+" , "+b+"]");
    }	
}
