package raytracer;


import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;


public class Film {
	ColorRT[][]  colorBucket;
	int widthPixels;
	int heightPixels;
	
	public Film(int h, int w){
		widthPixels = w;
		heightPixels = h;
		colorBucket = new ColorRT[heightPixels][widthPixels];
	}
	
	public void commit(Sample currentSample,ColorRT currentColor){
		ColorRT tempColor = colorBucket[currentSample.y][currentSample.x];
		if(tempColor != null){
			colorBucket[currentSample.y][currentSample.x] = tempColor.cAdd(currentColor);
		} else {
			colorBucket[currentSample.y][currentSample.x] = currentColor;
		}
	}
	
	public void writeImage(String filename){
		BufferedImage bimage = new BufferedImage(widthPixels, heightPixels, BufferedImage.TYPE_INT_RGB);
		for (int y = 0; y < heightPixels; y++){
			for (int x = 0; x < widthPixels; x++){
				ColorRT tempColorRT = colorBucket[y][x];				
				
				Color tempColor = new Color(Math.min(tempColorRT.r,1f),Math.min(tempColorRT.g,1f),Math.min(tempColorRT.b,1f));
				bimage.setRGB(x,y,tempColor.getRGB());
			}
		}

		try {
			File file = new File(filename);
			ImageIO.write(bimage, "png", file);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
