package raytracer;

public class LightDirected extends Light {
	public Vector3D direction;
	public Vector3D oppositeDirection;
	public ColorRT color;

	
	public LightDirected(Vector3D d,ColorRT c){
		direction = d;
		color = c;
		this.lightType = DIRECTED;
		oppositeDirection = Vector3D.oppositeVector(d);
	}
	
	public Vector3D getVectorToLight(Point intersection){
		return oppositeDirection;
	}
	
	public ColorRT getAmountOfLight(Point intersection){
		return color;
	}
	
	public String toString() {
		return new String("[LightDirected: " + direction + " " + color + " ]");
	}
}
