package raytracer;

public class LightPoint extends Light {
	public Point position;
	public ColorRT color;
	
	public LightPoint(Point pos,ColorRT color){
		position = pos;
		this.color = color;
		this.lightType = POINT;
	}
	
	@Override
	public Vector3D getVectorToLight(Point point) {
		Vector3D vec = position.pSubtract(point);
		return vec;
	}

	@Override
	public ColorRT getAmountOfLight(Point intersection) {
		// TODO Auto-generated method stub
		return color;
	}

}
