package raytracer;

public class Plane extends Shape {
	public Point v1,v2,v3;
	
	public Plane(Point v1,Point v2,Point v3){
		this.v1 = v1;
		this.v2 = v2;
		this.v3 = v3;
		shapeType = PLANE;
	}
	
	@Override
	public Intersection intersect(Ray ray) {
		Intersection returnIntersection = new Intersection();
		returnIntersection.intersectedShape = this;
		Vector3D u,v,n;
		u = v2.pSubtract(v1);
		v = v3.pSubtract(v1);
		n = u.cross(v);
		Vector3D w0 = (ray.position).pSubtract(v1);
		float a = -1.0f * n.dot(w0);
		float b = n.dot(ray.direction);
		System.out.println(a + " " + b);
		if(Math.abs(b) < 0.00000001){ // ray is parallel
			if(a == 0){ // ray lies on plane
				returnIntersection.distance = -1; 
				return returnIntersection;
			} else {
				returnIntersection.distance = -2; //disjoint from plane
				return returnIntersection;
			}
				
		}
		
		float r = a / b;
		if (r < 0.0) {				// ray goes away from plane
			returnIntersection.distance = -3; // no intersect
			return returnIntersection;
		}
		
		returnIntersection.distance = r;
		
		return returnIntersection;
	}

	@Override
	public Vector3D getNormal(Point point) {
		Vector3D u,v,n;
		u = v2.pSubtract(v1);
		v = v3.pSubtract(v1);
		n = u.cross(v);
		return n;
	}

}
