package raytracer;

public class Ray {
	public Point position;
	public Vector3D direction; //normalized
	public int depth;

	public Ray(Point pt,Vector3D dir){
		position = pt;
		dir.normalize();
		direction = dir;
		depth = 0;
	}

	public void slide(float t) {
		position.x += (direction.x*t);
		position.y += (direction.y*t);
		position.z += (direction.z*t);
	}

	public Point getPoint(float t)
	{
		return new Point(position.x + (t * direction.x), position.y + (t * direction.y), position.z + (t * direction.z));
	}
	

	public Ray(float x0, float y0, float z0, float x1, float y1, float z1)
	{
		position = new Point(x0, y0, z0);
		direction = new Vector3D(x1, y1, z1);
		direction.normalize();
		depth = 0;
	}

    public String toString() {
        return new String("[Ray: "+position+" + "+direction+"]");
    }
	
}
