package raytracer;

public class Scene {
	public Point eyePosition;
	public Point UL,UR,LL,LR;
	public int imgHeight,imgWidth; // size in pixels
	public Sample currentSample;
	public Film medium;
	
	
	public Scene(Point e,Point ul,Point ur,Point ll,Point lr,int h,int w,Film p){
		eyePosition = e;
		this.UL = ul;
		this.UR = ur;
		this.LL = ll;
		this.LR = lr;
		imgHeight = h;
		imgWidth = w;
		currentSample = new Sample(0,0);
		medium = p;
	}
	
	public Sample getSample(){
		
		Sample tempSample = currentSample;
		if(currentSample.x >= imgWidth-1){
			tempSample.y += 1;
			tempSample.x = 0;
		} else {
			tempSample.x += 1;
		}
		if(currentSample.y >= imgHeight){
			return null;
		}
		return tempSample;
	}
	
	public void render(Shape[] shapes,Light[] lights, String filename){
		while(currentSample != null){
			Camera sceneCamera = new Camera(eyePosition,this);
			Ray tempRay = sceneCamera.generateRay(currentSample);
			RayTracer tempRayTracer = new RayTracer(2,shapes,lights);
			medium.commit(currentSample,tempRayTracer.trace(tempRay,0));
			currentSample = getSample();
		}
		medium.writeImage(filename);
	}
}
