package raytracer;

public class Sphere extends Shape {
	public float radius;
	public Point center;


	
	public Sphere(float r,Point c){
		radius = r;
		center = c;
		shapeType = SPHERE;
	}
	
	public Intersection intersect(Ray ray){
		
		Vector3D L = center.pSubtract(ray.position);
		Vector3D V = ray.direction;
		Intersection returnIntersection = new Intersection();
		returnIntersection.intersectedShape = this;
		
		float tCA = L.dot(V);
		if (tCA < 0){
			// no intersection, camera is inside sphere or sphere behind the ray
			returnIntersection.distance = -1.0f;
			return returnIntersection;
		}
		
		float LSquare = L.dot(L);
		float dSquare = LSquare - (tCA * tCA);
		float radiusSquare = (radius * radius);
		
		if(dSquare > radiusSquare){
			// ray misses the sphere
			returnIntersection.distance = -1.0f;
			return returnIntersection;
		}
		
		float tHC = (float) Math.sqrt(radiusSquare - dSquare);
		
		if(L.dot(L) < LSquare){
			//ray originates in the sphere, intersection is at exit point
			returnIntersection.distance = tCA + tHC;
			return returnIntersection;
		} else {
			//ray originates outside of sphere, intersection at entrance point
			returnIntersection.distance = tCA - tHC;
			return returnIntersection;
		}
	}
	
	public Vector3D getNormal(Point point){
		Vector3D normal = center.pSubtract(point);
		normal.normalize();
		
		return normal;
	}
	
	public String toString(){
		return new String("[Sphere: "+center+" "+radius+" ]");
	}
	
	
}
