package raytracer;

public class Triangle extends Shape {
	public Point v1,v2,v3;
	
	public Triangle(Point v1,Point v2,Point v3){
		this.v1 = v1;
		this.v2 = v2;
		this.v3 = v3;
		shapeType = TRIANGLE;
	}
	
	@Override
	public Intersection intersect(Ray ray) {
		Intersection returnIntersection = new Intersection();
		returnIntersection.intersectedShape = this;
		Vector3D u,v,n;
		u = v2.pSubtract(v1);
		v = v3.pSubtract(v1);
		n = u.cross(v);
		Vector3D w0 = (ray.position).pSubtract(v1);
		float a = -1.0f * n.dot(w0);
		float b = n.dot(ray.direction);
		if(Math.abs(b) < 0.00000001){ // ray is parallel
			if(a == 0){ // ray lies on triangle plane
				returnIntersection.distance = -1; 
				return returnIntersection;
			} else {
				returnIntersection.distance = -2; //disjoint from plane
				return returnIntersection;
			}
				
		}
		
		float r = a / b;
		if (r < 0.0) {				// ray goes away from triangle
			returnIntersection.distance = -3; // no intersect
			return returnIntersection;
		}
		
		returnIntersection.distance = r;
		Point intersectionPoint = ray.getPoint(returnIntersection.distance); 
		
		//test if the intersectionPoint is in the triangle
		float uu,uv,vv,wu,wv,D;
		uu = u.dot(u);
		uv = u.dot(v);
		vv = v.dot(v);
		Vector3D w = intersectionPoint.pSubtract(v1);
		wu = w.dot(u);
		wv = w.dot(v);
		D = uv * uv - uu * vv;
		
		//test the parametric coords
		float s,t;
		s = (uv * wv - vv * wu) / D;
		if (s < 0.0 || s > 1.0)      // intersectionPoint is outside of triangle
			returnIntersection.distance = -4;
		t = (uv * wu - uu * wv) / D;
		if (t < 0.0 || (s + t) > 1.0) // intersectionPoint is outside triangle
			returnIntersection.distance = -4;
		
		
		return returnIntersection;
	}

	@Override
	public Vector3D getNormal(Point point) {
		Vector3D u,v,n;
		u = v2.pSubtract(v1);
		v = v3.pSubtract(v1);
		n = u.cross(v);
		return n;
	}

}
