package raytracer;

public class Vector3D {  //From an MIT project
    public float x, y, z;

    // constructors
    public Vector3D( ) {
    }

    public Vector3D(float x, float y, float z) {
        this.x = x; this.y = y; this.z = z;
    }

    public Vector3D(Vector3D v) {
        x = v.x;
        y = v.y;
        z = v.z;
    }

    // methods

  // Vector from this to B
  public final Vector3D to(Vector3D B) {
    return(new Vector3D(B.x - x, B.y - y, B.z - z));
  }

    public final float dot(Vector3D B) {
        return (x*B.x + y*B.y + z*B.z);
    }

    public final float dot(float Bx, float By, float Bz) {
        return (x*Bx + y*By + z*Bz);
    }

    public static final float dot(Vector3D A, Vector3D B) {
        return (A.x*B.x + A.y*B.y + A.z*B.z);
    }

    public final Vector3D cross(Vector3D B) {
        return new Vector3D(y*B.z - z*B.y, z*B.x - x*B.z, x*B.y - y*B.x);
    }

    public final Vector3D cross(float Bx, float By, float Bz) {
        return new Vector3D(y*Bz - z*By, z*Bx - x*Bz, x*By - y*Bx);
    }

    public final static Vector3D cross(Vector3D A, Vector3D B) {
        return new Vector3D(A.y*B.z - A.z*B.y, A.z*B.x - A.x*B.z, A.x*B.y - A.y*B.x);
    }

    public final float length( ) {
        return (float) Math.sqrt(x*x + y*y + z*z);
    }

    public final static float length(Vector3D A) {
        return (float) Math.sqrt(A.x*A.x + A.y*A.y + A.z*A.z);
    }

    public final void normalize( ) {
        float t = x*x + y*y + z*z;
        if (t != 0 && t != 1) t = (float) (1 / Math.sqrt(t));
        x *= t;
        y *= t;
        z *= t;
    }
    
    public final static Vector3D reflectVector(Vector3D vec,Vector3D normal){
    	float dotProd = vec.dot(normal);
    	
    	Vector3D r = new Vector3D((-1 * vec.x) + (2 * normal.x * dotProd),(-1 * vec.y) + (2 * normal.y * dotProd),(-1 * vec.z) + (2 * normal.z * dotProd));
    	
    	return r;
    }
    public final static Vector3D oppositeVector(Vector3D vec){
    	Vector3D r = new Vector3D(-1f * vec.x,-1f * vec.y,-1f * vec.z);
    	return r;
    }
    
    public final Vector3D sMultiply(float n){
    	return new Vector3D(n * x,n * y,n* z);
    }

    public final static Vector3D normalize(Vector3D A) {
        float t = A.x*A.x + A.y*A.y + A.z*A.z;
        if (t != 0 && t != 1) t = (float)(1 / Math.sqrt(t));
        return new Vector3D(A.x*t, A.y*t, A.z*t);
    }

    public String toString() {
        return new String("[Vec: "+x+", "+y+", "+z+"]");
    }
}

